import { registerPaymentMethod } from '@woocommerce/blocks-registry';
import { __, sprintf } from '@wordpress/i18n';
import { createElement, Fragment } from '@wordpress/element';

const settings = window.peiBlocksData ?? {};

/* a minimal, empty element for the editor sidebar */
const EditPlaceholder = createElement( Fragment, null );

registerPaymentMethod( {
	name: 'dg_pei',

	/* shopper‑facing */
	label: (
		<span className="pei-label">
			<img
				src={ settings.logo }
				alt=""
				style={ { maxHeight: 25, marginRight: 6 } }
			/>
			{ settings.title }
		</span>
	),
	content: <p>{ settings.description }</p>,

	/* a11y + editor */
	ariaLabel: sprintf( __( '%s payment method', 'pei' ), settings.title ),
	edit: EditPlaceholder,          //  ← React element, not null, not a function

	/* runtime */
	canMakePayment: () => true,
	supports: { features: [ 'products' ] },
} );
