<?php
/**
 * Plugin Name: Pei for WooCommerce
 * Description: Pei payment gateway
 * Plugin URI: https://www.ok.is
 * Version: 4.0.9
 * Author: OK
 * Author URI: https://www.ok.is
 * Requires: PHP 7.4+, WooCommerce 6.7+
 */

defined( 'ABSPATH' ) || exit;

const PEI_WC_PLUGIN_DIR = __DIR__;

// 1️⃣  Load the original gateway (refactored into its own file)
add_action( 'woocommerce_loaded', function () {
    require_once PEI_WC_PLUGIN_DIR . '/includes/class-wc-gateway-pei.php';
    add_filter(
        'woocommerce_payment_gateways',
        function ( $gateways ) {
            $gateways[] = \Premis\Pei\WC_Gateway_Pei::class;
            return $gateways;
        }
    );
} );

// 2️⃣  Load Blocks integration if Blocks is present
add_action( 'woocommerce_blocks_loaded', function () {
    // Only load if the abstract class exists (keeps WC<6 sites from fatalling)
    if ( class_exists( '\Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType' ) ) {
        require_once PEI_WC_PLUGIN_DIR . '/includes/blocks/class-pei-blocks.php';

        add_filter(
            'woocommerce_blocks_payment_method_type_registration',
            function ( \Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $registry ) {
                $registry->register( new \Premis\Pei\Blocks\Pei_Blocks_Integration() );
            }
        );
    }
} );
