<?php
namespace Premis\Pei\Blocks;

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

final class Pei_Blocks_Integration extends AbstractPaymentMethodType {

	protected $name = 'dg_pei';          // MUST match the name used in JS

	public function initialize() : void {
		$this->settings = get_option( 'woocommerce_dg_pei_settings', [] );
	}

	/** Should the payment appear in the block UI? */
	public function is_active() : bool {
		return (bool) ( $this->settings['enabled'] ?? false );
	}

	/** Tell Blocks which JS handles to enqueue on the front‑end checkout. */
	public function get_payment_method_script_handles() : array {
		if ( defined( 'WP_DEBUG' ) && WP_DEBUG ) {
			$script_path = '/build/index.js';
		} else {
			$script_path = '/build/index.js';
		}

		$handle = 'pei-blocks-js';

		wp_register_script(
			$handle,
			plugins_url( $script_path, PEI_WC_PLUGIN_DIR . '/pei-woocommerce.php' ),
			[ 'wc-blocks-registry', 'wp-element', 'wp-i18n' ],
			filemtime( PEI_WC_PLUGIN_DIR . $script_path ),
			true
		);

		// Localise any data the JS side needs (logo url etc)
		wp_add_inline_script(
			$handle,
			'window.peiBlocksData = ' . wp_json_encode( [
				'title'       => __( 'Pei', 'pei' ),
				'description' => __( 'Pay with the Pei app', 'pei' ),
				'logo'        => plugins_url( '/assets/pei_logo_small.png', PEI_WC_PLUGIN_DIR . '/pei-woocommerce.php' ),
			] ),
			'before'
		);

		return [ $handle ];
	}

	/** Data handed to JS via the StoreAPI */
	public function get_payment_method_data() : array {
		return [
			'title'       => __( 'Pei', 'pei' ),
			'description' => __( 'Pay with the Pei app', 'pei' ),
			'supports'    => [ 'products' ],
		];
	}
}
